% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/meltAssay.R
\name{meltSE}
\alias{meltSE}
\alias{meltSE,SummarizedExperiment-method}
\alias{meltSE,SingleCellExperiment-method}
\title{Converting a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object into a long data.frame}
\usage{
meltSE(x, ...)

\S4method{meltSE}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  add.row = add_row_data,
  add_row_data = NULL,
  add.col = add_col_data,
  add_col_data = NULL,
  row.name = feature_name,
  feature_name = "FeatureID",
  col.name = sample_name,
  sample_name = "SampleID",
  ...
)

\S4method{meltSE}{SingleCellExperiment}(x, add.dimred = NULL, ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{optional arguments:
\itemize{
\item check.names: \code{Logical scalar}. Passed to data.frame
function's check.name argument. Determines if sample names are checked
that they are syntactically valid variable names and are not duplicated.
If they are not, sample names are modified. (Default: \code{TRUE})
}}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{add.row}{\code{Logical scalar} or \code{Character vector}. To
select information from the \code{rowData} to add to the molten assay data.
If \code{add.row = NULL} no data will be added, if
\code{add.row = TRUE} all data will be added and if
\code{add.row} is a \code{character} vector, it will be used to subset
to given column names in \code{rowData}. (Default: \code{NULL})}

\item{add_row_data}{Deprecated. Use \code{add.row} instead.}

\item{add.col}{\code{Logical scalar}. \code{NULL}, or
\code{character vector}. Used to select information from the \code{colData}
to add to the molten assay data. If \code{add.col = NULL} no data will
be added, if \code{add.col = TRUE} all data will be added and if
\code{add.col} is a \code{character} vector, it will be used to subset
to given column names in \code{colData}. (Default: \code{NULL})}

\item{add_col_data}{Deprecated. Use \code{add.col} instead.}

\item{row.name}{\code{Character scalar}. To use as the output's name
for the feature identifier. (Default: \code{"FeatureID"})}

\item{feature_name}{Deprecated. Use \code{row.name} instead.}

\item{col.name}{\code{Character scalar}. To use as the output's name
for the sample identifier. (Default: \code{"SampleID"})}

\item{sample_name}{Deprecated. Use \code{col.name} instead.}

\item{add.dimred}{\code{Logical scalar} or \code{Character vector}. To
select information from the \code{reducedDim} to add to the molten assay
data. If \code{add.dimred = NULL} no data will be added, if
\code{add.dimred = TRUE} all data will be added and if
\code{add.dimred} is a \code{character} vector, it will be used to subset
to given names in \code{reducedDimNames(x)}. (Default: \code{NULL})}
}
\value{
A \code{tibble} with the molten data. The assay values are given in a
column named like the selected assay \code{assay.type}. In addition, a
column \dQuote{FeatureID} will contain the rownames, if set, and analogously
a column \dQuote{SampleID} with the colnames, if set.
}
\description{
\code{meltSE} Converts a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object into a long data.frame which can be used for \code{tidyverse}-tools.
}
\details{
If the \code{colData} contains a column \dQuote{SampleID} or the
\code{rowData} contains a column \dQuote{FeatureID}, they will be renamed to
\dQuote{SampleID_col} and \dQuote{FeatureID_row}, if row names or column
names are set.
}
\examples{
data(GlobalPatterns)
molten_tse <- meltSE(
    GlobalPatterns,
    assay.type = "counts",
    add.row = TRUE,
    add.col = TRUE
    )
molten_tse
}
