% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/runNMDS.R
\name{getNMDS}
\alias{getNMDS}
\alias{runNMDS}
\alias{getNMDS,ANY-method}
\alias{getNMDS,SummarizedExperiment-method}
\alias{getNMDS,SingleCellExperiment-method}
\alias{calculateNMDS}
\alias{addNMDS}
\title{Perform non-metric MDS on sample-level data}
\usage{
getNMDS(x, ...)

\S4method{getNMDS}{ANY}(
  x,
  FUN = vegdist,
  nmds.fun = nmdsFUN,
  nmdsFUN = c("isoMDS", "monoMDS"),
  ncomponents = 2,
  ntop = 500,
  subset.row = subset_row,
  subset_row = NULL,
  scale = FALSE,
  transposed = FALSE,
  keep.dist = keep_dist,
  keep_dist = FALSE,
  ...
)

\S4method{getNMDS}{SummarizedExperiment}(
  x,
  ...,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  FUN = vegdist
)

\S4method{getNMDS}{SingleCellExperiment}(
  x,
  ...,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  dimred = NULL,
  ndimred = n_dimred,
  n_dimred = NULL,
  FUN = vegdist
)

calculateNMDS(x, ...)

addNMDS(x, ..., altexp = NULL, name = "NMDS")

runNMDS(x, ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional arguments to pass to \code{FUN} and
\code{nmds.fun}.}

\item{FUN}{\code{Function} or \code{Character scalar}. A value with a
function name returning a \code{\link[stats:dist]{dist}} object}

\item{nmds.fun}{\code{Character scalar}. A value to choose the scaling
implementation, either \dQuote{isoMDS} for
\code{\link[MASS:isoMDS]{MASS::isoMDS}} or \dQuote{monoMDS} for
\code{\link[vegan:monoMDS]{vegan::monoMDS}}}

\item{nmdsFUN}{Deprecated. Use \code{nmds.fun} instead.}

\item{ncomponents}{\code{Numeric scalar}. Indicates the number of DPCoA
dimensions to obtain. (Default: \code{2})}

\item{ntop}{\code{Numeric scalar}. Specifies the number of features with the
highest variances to use for dimensionality reduction. Alternatively
\code{NULL}, if all features should be used. (Default: \code{NULL})}

\item{subset.row}{\code{Character Vector}. Specifies the subset of features
to use for dimensionality reduction. This can be a character vector of row
names, an integer vector of row indices or a logical vector.
(Default: \code{NULL})}

\item{subset_row}{Deprecated. Use \code{subset.row} instead.}

\item{scale}{\code{Logical scalar}. Should the expression values be
standardized? (Default: \code{FALSE})}

\item{transposed}{\code{Logical scalar}. Specifies if x is transposed with
cells in rows. (Default: \code{FALSE})}

\item{keep.dist}{\code{Logical scalar}. Indicates whether the \code{dist}
object calculated by \code{FUN} should be stored as \sQuote{dist} attribute
of the matrix returned/stored by \code{getNMDS}/ \code{addNMDS}. (Default:
\code{FALSE})}

\item{keep_dist}{Deprecated. Use \code{keep.dist} instead.}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{exprs_values}{Deprecated. Use \code{assay.type} instead.}

\item{dimred}{\code{Character scalar} or \code{integer scalar}. Specifies
the existing dimensionality reduction results to use.}

\item{ndimred}{\code{integer vector}. Specifies the dimensions to use if
dimred is specified.}

\item{n_dimred}{Deprecated. Use \code{ndimred} instead.}

\item{altexp}{\code{Character scalar} or \code{integer scalar}. Specifies an
alternative experiment containing the input data. (Default: \code{NULL})}

\item{name}{\code{Character scalar}. A name for the column of the
\code{colData} where results will be stored. (Default: \code{"NMDS"})}
}
\value{
For \code{getNMDS}, a matrix is returned containing the MDS
coordinates for each sample (row) and dimension (column).
}
\description{
Perform non-metric multi-dimensional scaling (nMDS) on samples, based on the
data in a \code{SingleCellExperiment} object.
}
\details{
For \code{addNMDS} a
\code{\link[TreeSummarizedExperiment]{TreeSummarizedExperiment}}

Either \code{\link[MASS:isoMDS]{MASS::isoMDS}} or
\code{\link[vegan:monoMDS]{vegan::monoMDS}} are used internally to compute
the NMDS components. If you supply a custom \code{FUN}, make sure that
the arguments of \code{FUN} and \code{nmds.fun} do not collide.
}
\examples{
# generate some example data
mat <- matrix(1:60, nrow = 6)
df <- DataFrame(n = c(1:6))
tse <- TreeSummarizedExperiment(assays = list(counts = mat),
                                rowData = df)
#
getNMDS(tse)

#
data(esophagus)
esophagus <- addNMDS(esophagus, FUN = vegan::vegdist, name = "BC")
esophagus <- addNMDS(esophagus, FUN = vegan::vegdist, name = "euclidean",
                     method = "euclidean")
reducedDims(esophagus)
}
\seealso{
\code{\link[MASS:isoMDS]{MASS::isoMDS}},
\code{\link[vegan:monoMDS]{vegan::monoMDS}}
for NMDS component calculation.

\code{\link[scater:plotReducedDim]{plotMDS}}, to quickly visualize the
results.
}
