% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rarefyAssay.R
\name{rarefyAssay}
\alias{rarefyAssay}
\alias{rarefyAssay,SummarizedExperiment-method}
\title{Subsample Counts}
\usage{
rarefyAssay(x, ...)

\S4method{rarefyAssay}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  sample = min_size,
  min_size = min(colSums2(assay(x, assay.type))),
  replace = FALSE,
  name = "subsampled",
  ...
)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{optional arguments:
\itemize{
\item \code{verbose}: \code{Logical scalar}. Choose whether to show
messages. (Default: \code{TRUE})
}}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{sample}{\code{Integer scalar}. Indicates the number of counts being
simulated i.e. rarefying depth. This can equal to lowest number of total
counts found in a sample or a user specified number.}

\item{min_size}{Deprecated. Use \code{sample} instead.}

\item{replace}{\code{Logical scalar}. Whether to åperform subsampling with
replacement. Ths works similarly to \code{sample(..., replace = TRUE)}.
(Default: \code{FALSE})}

\item{name}{\code{Character scalar}. The name for the transformed assay to
be stored. (Default: \code{method})}
}
\value{
\code{rarefyAssay} return \code{x} with subsampled data.
}
\description{
\code{rarefyAssay} randomly subsamples counts within a
\code{SummarizedExperiment} object and returns a new
\code{SummarizedExperiment} containing the original assay and the new
subsampled assay.
}
\details{
Although the subsampling approach is highly debated in microbiome research,
we include the \code{rarefyAssay} function because there may be some
instances where it can be useful.
Note that the output of \code{rarefyAssay} is not the equivalent as the
input and any result have to be verified with the original dataset.

Subsampling/Rarefying may undermine downstream analyses and have unintended
consequences. Therefore, make sure this normalization is appropriate for
your data.

To maintain the reproducibility, please define the seed using set.seed()
before implement this function.

When \code{replace = FALSE}, the function uses internally
\code{vegan::rarefy} while with replacement enabled the function utilizes
own implementation, inspired by \code{phyloseq::rarefy_even_depth}.
}
\examples{
# When samples in TreeSE are less than specified sample, they will be
# removed. If after subsampling features are not present in any of the
# samples, they will be removed.
data(GlobalPatterns)
tse <- GlobalPatterns
set.seed(123)
tse_subsampled <- rarefyAssay(tse, sample = 60000, name = "subsampled")
tse_subsampled
dim(tse)
dim(assay(tse_subsampled, "subsampled"))

}
\references{
McMurdie PJ, Holmes S. Waste not, want not: why rarefying microbiome data
is inadmissible. PLoS computational biology. 2014 Apr 3;10(4):e1003531.

Gloor GB, Macklaim JM, Pawlowsky-Glahn V & Egozcue JJ (2017)
Microbiome Datasets Are Compositional: And This Is Not Optional.
Frontiers in Microbiology 8: 2224. doi: 10.3389/fmicb.2017.02224

Weiss S, Xu ZZ, Peddada S, Amir A, Bittinger K, Gonzalez A, Lozupone C,
Zaneveld JR, Vázquez-Baeza Y, Birmingham A, Hyde ER. Normalization and
microbial differential abundance strategies depend upon data characteristics.
Microbiome. 2017 Dec;5(1):1-8.
}
\seealso{
\itemize{
\item \code{\link[vegan:rrarefy]{vegan::rrarefy}}
\item \code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth}}
}
}
