% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getPrevalence.R
\name{agglomerateByPrevalence}
\alias{agglomerateByPrevalence}
\alias{agglomerateByPrevalence,SummarizedExperiment-method}
\alias{agglomerateByPrevalence,TreeSummarizedExperiment-method}
\title{Agglomerate data based on population prevalence}
\usage{
agglomerateByPrevalence(x, ...)

\S4method{agglomerateByPrevalence}{SummarizedExperiment}(
  x,
  rank = NULL,
  other.name = other_label,
  other_label = "Other",
  ...
)

\S4method{agglomerateByPrevalence}{TreeSummarizedExperiment}(
  x,
  rank = NULL,
  other.name = other_label,
  other_label = "Other",
  update.tree = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{arguments passed to \code{agglomerateByRank} function for
\code{SummarizedExperiment} objects and other functions.
See \code{\link[=agglomerate-methods]{agglomerateByRank}} for more details.}

\item{rank}{\code{Character scalar}. Defines a taxonomic rank. Must be a
value of \code{taxonomyRanks()} function.}

\item{other.name}{\code{Character scalar}. Used as the label for the
summary of non-prevalent taxa. (default: \code{"Other"})}

\item{other_label}{Deprecated. use \code{other.name} instead.}

\item{update.tree}{\code{Logical scalar}. Should
\code{rowTree()} also be merged? (Default: \code{TRUE})}
}
\value{
\code{agglomerateByPrevalence} returns a taxonomically-agglomerated object
of the same class as x and based on prevalent taxonomic results.
}
\description{
Agglomerate data based on population prevalence
}
\details{
\code{agglomerateByPrevalence} sums up the values of assays at the taxonomic
level specified by \code{rank} (by default the highest taxonomic level
available) and selects the summed results that exceed the given population
prevalence at the given detection level. The other summed values (below the
threshold) are agglomerated in an additional row taking the name indicated by
\code{other.name} (by default "Other").
}
\examples{
## Data can be aggregated based on prevalent taxonomic results
data(GlobalPatterns)
tse <- GlobalPatterns
tse <- transformAssay(tse, method = "relabundance")
tse <- agglomerateByPrevalence(
    tse,
    rank = "Phylum",
    assay.type = "relabundance",
    detection = 1/100,
    prevalence = 50/100)

tse

# Here data is aggregated at the taxonomic level "Phylum". The five phyla
# that exceed the population prevalence threshold of 50/100 represent the
# five first rows of the assay in the aggregated data. The sixth and last row
# named by default "Other" takes the summed up values of all the other phyla
# that are below the prevalence threshold.

assay(tse)[,1:5]

}
