% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotPrevalence.R
\name{plotRowPrevalence}
\alias{plotRowPrevalence}
\alias{plotPrevalentAbundance}
\alias{plotPrevalence}
\alias{plotPrevalence,SummarizedExperiment-method}
\alias{plotPrevalentAbundance,SummarizedExperiment-method}
\alias{plotRowPrevalence,SummarizedExperiment-method}
\title{Plot prevalence information}
\usage{
plotRowPrevalence(x, ...)

plotPrevalentAbundance(x, ...)

plotPrevalence(x, ...)

\S4method{plotPrevalence}{SummarizedExperiment}(
  x,
  detection = detections,
  detections = c(0.01, 0.1, 1, 2, 5, 10, 20),
  prevalence = prevalences,
  prevalences = seq(0.1, 1, 0.1),
  assay.type = assay_name,
  assay_name = "counts",
  rank = NULL,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)

\S4method{plotPrevalentAbundance}{SummarizedExperiment}(
  x,
  rank = NULL,
  assay.type = assay_name,
  assay_name = "counts",
  colour.by = colour_by,
  colour_by = NULL,
  size.by = size_by,
  size_by = NULL,
  shape.by = shape_by,
  shape_by = NULL,
  show.label = label,
  label = NULL,
  facet.by = facet_by,
  facet_by = NULL,
  ...
)

\S4method{plotRowPrevalence}{SummarizedExperiment}(
  x,
  rank = NULL,
  assay.type = assay_name,
  assay_name = "counts",
  detection = detections,
  detections = c(0.01, 0.1, 1, 2, 5, 10, 20),
  min.prevalence = min_prevalence,
  min_prevalence = 0,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{detection}{\code{Numeric scalar}. Detection thresholds for
absence/presence. Either an absolutes value compared directly to the values
of \code{x} or a relative value between 0 and 1, if \code{TRUE}.}

\item{detections}{Deprecated. Use \code{detection} instead.}

\item{prevalence}{\code{Numeric scalar}. Prevalence thresholds (in 0 to 1).
The required prevalence is strictly greater by default. To include the
limit, set \code{include.lowest} to \code{TRUE}.}

\item{prevalences}{Deprecated. Use \code{prevalence} instead.}

\item{assay.type}{\code{Character scalar}. Defines which assay data to
use. (Default: \code{"relabundance"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{rank, ...}{additional arguments
\itemize{
\item as.relative \code{Logical scalar}. Should the relative values
be calculated? (Default: \code{FALSE})

\item ndetection \code{Integer scalar}. Determines the number of breaks
calculated detection thresholds when \code{detection=NULL}. When
\code{TRUE},  \code{as_relative} is then also regarded as \code{TRUE}.
(Default: \code{20})

\item{If \code{!is.null(rank)} matching arguments are passed on to
\code{\link[=agglomerate-methods]{agglomerateByRank}}. See
\code{\link[=agglomerate-methods]{?agglomerateByRank}} for more details.
}

\item{additional arguments for plotting. See
\code{\link{mia-plot-args}} for more details i.e. call
\code{help("mia-plot-args")}}
}}

\item{BPPARAM}{A
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}}
object specifying whether the UniFrac calculation should be parallelized.}

\item{colour.by}{\code{Character scalar}. Specification of a feature to
colour points by, see the \code{by} argument in
\code{\link[scater:retrieveFeatureInfo]{?retrieveFeatureInfo}} for
possible values. Only used with \code{layout = "point"}.
(Default: \code{NULL})}

\item{colour_by}{Deprecated. Use \code{colour.by} instead.}

\item{size.by}{\code{Character scalar}. Specification of a feature to size
points by, see the \code{by} argument in
\code{\link[scater:retrieveFeatureInfo]{?retrieveFeatureInfo}} for
possible values. Only used with \code{layout = "point"}.
(Default: \code{NULL})}

\item{size_by}{Deprecated. Use \code{size.by} instead.}

\item{shape.by}{\code{Character scalar}. Specification of a feature to shape
points by, see the \code{by} argument in
\code{\link[scater:retrieveFeatureInfo]{?retrieveFeatureInfo}} for
possible values. Only used with \code{layout = "point"}.
(Default: \code{NULL})}

\item{shape_by}{Deprecated. Use \code{shape.by} instead.}

\item{show.label}{\code{Logical scalar}, \code{character scalar} or
\code{integer vector} for selecting labels from the rownames of \code{x}.
If \code{rank} is not \code{NULL} the rownames might change.
(Default: \code{NULL})}

\item{label}{Deprecated. Use \code{show.label} instead.}

\item{facet.by}{\code{Character scalar}. Taxonomic rank to facet the plot by.
Value must be of \code{taxonomyRanks(x)}
Argument can only be used in function plotPrevalentAbundance.}

\item{facet_by}{Deprecated. Use \code{facet.by} instead.}

\item{min.prevalence}{\code{Numeric scalar}. Applied as a threshold for
plotting. The threshold is applied per row and column.
(Default: \code{0})}

\item{min_prevalence}{Deprecated. Use \code{min.prevalence} instead.}
}
\value{
A \code{ggplot2} object or \code{plotly} object, if more than one
\code{prevalence} was defined.
}
\description{
\code{plotPrevalence} and \code{plotRowPrevalence} visualize prevalence
information.
}
\details{
Whereas \code{plotPrevalence} produces a line plot, \code{plotRowPrevalence}
returns a heatmap.

Agglomeration on different taxonomic levels is available through the
\code{rank} argument.

To exclude certain taxa, preprocess \code{x} to your liking, for example
with subsetting via \code{getPrevalent} or
\code{agglomerateByPrevalence}.
}
\examples{
data(GlobalPatterns, package = "mia")

# Apply relative transformation
GlobalPatterns <- transformAssay(GlobalPatterns, method = "relabundance")

# plotting N of prevalence exceeding taxa on the Phylum level
plotPrevalence(GlobalPatterns, rank = "Phylum")
plotPrevalence(GlobalPatterns, rank = "Phylum") + scale_x_log10()

# plotting prevalence per taxa for different detection thresholds as heatmap
plotRowPrevalence(GlobalPatterns, rank = "Phylum")

# by default a continuous scale is used for different detection levels,
# but this can be adjusted
plotRowPrevalence(
    GlobalPatterns, rank = "Phylum", assay.type = "relabundance",
    detection = c(0, 0.001, 0.01, 0.1, 0.2))

# point layout for plotRowPrevalence can be used to visualize by additional
# information
plotPrevalentAbundance(
    GlobalPatterns, rank = "Family", colour.by = "Phylum") +
    scale_x_log10()

# When using function plotPrevalentAbundace, it is possible to create facets
# with 'facet.by'.
plotPrevalentAbundance(
    GlobalPatterns, rank = "Family",
    colour.by = "Phylum", facet.by = "Kingdom") +
    scale_x_log10()
}
\seealso{
\code{\link[mia:getPrevalence]{getPrevalence}},
\code{\link[mia:getPrevalence]{agglomerateByPrevalence}},
\code{\link[mia:agglomerate-methods]{agglomerateByRank}}
}
