% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getStability.R
\name{getStability}
\alias{getStability}
\alias{addStability}
\alias{addStability,SummarizedExperiment-method}
\alias{getStability,SummarizedExperiment-method}
\title{Estimate stability}
\usage{
getStability(x, ...)

addStability(x, ...)

\S4method{addStability}{SummarizedExperiment}(x, time.col, name = "stability", ...)

\S4method{getStability}{SummarizedExperiment}(
  x,
  time.col,
  assay.type = "counts",
  reference = NULL,
  group = NULL,
  ...
)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{additional arguments.
\itemize{
\item \code{time.interval}: \code{Integer scalar}. Indicates the increment
between time steps. By default, the function compares each sample to the
previous one. If you need to take every second, every third, or so, time
step, then increase this accordingly. (Default: \code{1L})

\item \code{calc.separately}: \code{Logical scalar}. Specifies whether to
calculate stability separately for data points with abundance below or
at/above the reference point. (Defaul: \code{FALSE})

\item \code{mode}: \code{Character scalar}. Specifies whether to calculate
stability using correlation ("correlation") or a linear model ("lm").
(Default: \code{"correlation"})
}}

\item{time.col}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the sampling time points for the samples.}

\item{name}{\code{Character scalar}. Specifies a column name for storing
stability results. (Default: \code{"stability"})}

\item{assay.type}{\code{Character scalar}. Specifies which assay values are
used in the dissimilarity estimation. (Default: \code{"counts"})}

\item{reference}{\code{Character scalar}. Specifies a column from
\code{rowData(x)} that determines the reference points. If \code{NULL},
the default reference is used. (Default: \code{NULL})}

\item{group}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the grouping of the samples.
(Default: \code{NULL})}
}
\value{
\code{getStability} returns \code{DataFrame} while \code{addStability}
returns results added to its \code{rowData(x)}.
}
\description{
Quantify intermediate stability with respect to a given reference point.
}
\details{
These methods estimate intermediate stability described in Lahti et al. 2014.
The method is heuristic and makes many simplifying assumptions. However, the
stability estimation can be useful for exploration, and can provide a
baseline for more advanced measures.

The stability is calculated by first defining reference point, \eqn{R_{f}},
for each feature. User can define the reference points with \code{reference}.
If reference points are not defined, they are calculated by taking median

\deqn{R_{f} = median(x_{f})}

where \eqn{f} denotes a single feature and \eqn{x} abundance.

Then difference between consecutive time points, \eqn{\Delta_{f, x}},

\deqn{\Delta_{f, x} = \vert x_{f, t} - x_{f, t-1} \vert}

and difference between the previous time point and reference,
\eqn{\Delta_{f. R}}, are calculated:

\deqn{\Delta_{f. R} = \vert x_{f, t-1} - R_{f} \vert}

where \eqn{t} denotes time point.

Optionally, time difference \eqn{\Delta_{f, t}} is calculated

\deqn{\Delta_{f, t} = t_{f, t-1} - t_{f, t-1}}

The stability coefficient \eqn{s_{f}} is calculated with correlation

\deqn{s_{f} = corr(\Delta_{f, x}, \Delta_{f, R})}

or with linear model as follows

\deqn{s_{f} = \frac{ \Delta_{f, x} - \beta_{0} - \beta_{2}*\Delta_{f, t} -
\epsilon_{f} }{ \Delta_{f, R} }}
}
\examples{
library(miaTime)

# Load time series data
data(minimalgut)
tse <- minimalgut

# Apply clr transformation
tse <- transformAssay(tse, method = "rclr")

# Calculate stability single system
tse_sub <- tse[, tse[["StudyIdentifier"]] == "Bioreactor A"]
tse_sub <- addStability(tse_sub, assay.type = "rclr", time.col = "Time.hr")
rowData(tse_sub)

# Add custom reference values
rowData(tse)[["ref_col"]] <- 1
# Calculate stability for each system simultaneously by taking time
# difference into account
tse <- addStability(
    tse, assay.type = "rclr", time.col = "Time.hr",
    group = "StudyIdentifier", ref_col = "ref_col", mode = "lm")
rowData(tse)

}
\references{
Lahti L, et al. (2014) Tipping elements in the human intestinal ecosystem.
Nat Commun. doi: 10.1038/ncomms5344
}
\seealso{
\code{\link[miaTime:getBimodality]{getBimodality()}}
}
