% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_miRtarget}
\alias{module_miRtarget}
\title{module_miRtarget}
\usage{
module_miRtarget(share_miRs, Modulelist)
}
\arguments{
\item{share_miRs}{List object: a list of common miRNAs of each miRNA sponge module 
generated by share_miRs function.}

\item{Modulelist}{List object: a list of the identified miRNA sponge modules.}
}
\value{
List object: miRNA-target interactions of each miRNA sponge module.
}
\description{
Extract miRNA-target interactions of each miRNA sponge module
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM_WGCNA_share_miRs <-  share_miRs(miRExp, miRTarget, miRSM_WGCNA_SRVC_genes)
miRSM_WGCNA_miRtarget <- module_miRtarget(miRSM_WGCNA_share_miRs, 
                                          miRSM_WGCNA_SRVC_genes)

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
