% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_miRsponge}
\alias{module_miRsponge}
\title{module_miRsponge}
\usage{
module_miRsponge(Modulelist)
}
\arguments{
\item{Modulelist}{List object: a list of the identified miRNA sponge modules.}
}
\value{
List object: miRNA sponge interactions of each miRNA sponge module.
}
\description{
Extract miRNA sponge interactions of each miRNA sponge module
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM_WGCNA_miRsponge <- module_miRsponge(miRSM_WGCNA_SRVC_genes)

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
