% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_group_sim}
\alias{module_group_sim}
\title{module_group_sim}
\usage{
module_group_sim(Module.group1, Module.group2, sim.method = "Simpson")
}
\arguments{
\item{Module.group1}{List object, the first list of module group.}

\item{Module.group2}{List object, the second list of module group.}

\item{sim.method}{Methods for calculating similatiry between two modules, select one of three methods (Simpson, Jaccard and Lin). Default method is Simpson.}
}
\value{
Similarity between two list of module groups
}
\description{
Calculating similarity between two list of module groups
}
\examples{
library(GSEABase)
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp) 
modulegenes_igraph <- module_igraph (ceRExp, mRExp) 
Sim <- module_group_sim(geneIds(modulegenes_WGCNA), geneIds(modulegenes_igraph))

}
\references{
Simpson E H. Measurement of diversity. Nature, 1949, 163(4148): 688-688.

Jaccard P. The distribution of the flora in the alpine zone. 1. New phytologist, 1912, 11(2): 37-50.

Lin D. An information-theoretic definition of similarity. in: Icml. 1998, 98(1998): 296-304.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
