% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{cor_binary}
\alias{cor_binary}
\title{cor_binary}
\usage{
cor_binary(
  ceRExp,
  mRExp = NULL,
  cor.method = "pearson",
  pos.p.value.cutoff = 0.01
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{cor.method}{The method of calculating correlation selected, 
including 'pearson' (default), 'kendall', 'spearman'.}

\item{pos.p.value.cutoff}{The significant p-value cutoff of 
positive correlation.}
}
\value{
A binary matrix.
}
\description{
Generation of positively correlated binary matrix between 
ceRNAs, or ceRNAs and mRNAs
}
\examples{
data(BRCASampleData)
cor_binary_matrix <- cor_binary(ceRExp, mRExp)

}
\references{
Langfelder P, Horvath S. WGCNA: an R package for 
weighted correlation network analysis. BMC Bioinformatics. 
2008, 9:559.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
