% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{goTo_miRNAFamily}
\alias{goTo_miRNAFamily}
\title{Open the miRNA family webpages of the specified miRNAs}
\usage{
goTo_miRNAFamily(FamilyAccessions, verbose = TRUE)
}
\arguments{
\item{FamilyAccessions}{A character vector representing the miRNA family Accessions in miRBase.
We restict the queried number of miRNA family each time. The maximum number of the input miRNA families is 15.}

\item{verbose}{Logical value. If true, the invalid miRNA Family will be printed the console.}
}
\value{
No values
}
\description{
This function redirects the miRBase miRNA family webpages of the specified miRNA families
}
\examples{
data(miRNATest)
Accessions=miRNATest$Accession
Family_Info=checkMiRNAFamily(Accessions)
FamilyAccessions=Family_Info$FamilyAccession[1:15]
goTo_miRNAFamily(FamilyAccessions)
}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
