% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_loci_by_group_coverage.R
\name{filter_loci_by_group_coverage}
\alias{filter_loci_by_group_coverage}
\title{Filter loci based on coverage threshold per sample per group}
\usage{
filter_loci_by_group_coverage(bs, group_column, min_samples_per_group)
}
\arguments{
\item{bs}{a \code{BSseq} object.}

\item{group_column}{a \code{character} string indicating the column of \code{pData(bs)} to use for determining group membership.}

\item{min_samples_per_group}{a named \code{integer} vector indicating the minimum number of samples with non-zero coverage required for maintaining a locus.}
}
\value{
A \code{BSseq} object with only those loci having \code{min_samples_per_group}.
}
\description{
An optional function to remove loci not satisfying coverage thresholds from \code{filter_loci_by_coverage} in a minimum number of samples per group.
}
\details{
The \code{filter_loci_by_coverage} function marked locus/sample pairs in the coverage matrix as 0 if said pair had coverage less than \code{minCount} or more than \code{maxCount}. This function enforces a threshold on the minimum number of samples per group required for a locus to be tested in downstream testing functions.
}
\examples{
data(BS.cancer.ex, package = 'bsseqData')

filter_loci_by_group_coverage(
    bs = BS.cancer.ex,
    group_column = 'Type',
    min_samples_per_group = c('cancer' = 3, 'normal' = 3)
)

}
