% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_loci_by_coverage.R
\name{filter_loci_by_coverage}
\alias{filter_loci_by_coverage}
\title{Filter BSseq object by coverage}
\usage{
filter_loci_by_coverage(bs, min_count = 5, max_count = 500)
}
\arguments{
\item{bs}{a \code{BSseq} object resulting from \code{bsseq::read.bismark} or constructed manually by the user.}

\item{min_count}{an \code{integer} giving the minimum coverage required at a locus.}

\item{max_count}{an \code{integer} giving the maximum coverage allowed at a locus.}
}
\value{
A \code{BSseq} object with samples/loci in the coverage and methylation matrix set to 0 where the coverage was less than \code{min_count} or greater than \code{max_count}. The number of samples and loci are conserved.
}
\description{
Used after \code{bsseq::read.bismark} to mark loci in samples below \code{min_count} or above \code{max_count} to 0. These loci will then be removed prior to differential analysis by \code{filter_loci_by_group_coverage()} if there are not a sufficient number of samples with appropriate coverage.
}
\examples{
bis_cov_file1 = system.file('extdata', 'bis_cov1.cov', package = 'methylSig')
bis_cov_file2 = system.file('extdata', 'bis_cov2.cov', package = 'methylSig')
test = bsseq::read.bismark(
    files = c(bis_cov_file1, bis_cov_file2),
    colData = data.frame(row.names = c('test1','test2')),
    rmZeroCov = FALSE,
    strandCollapse = FALSE
)
test = filter_loci_by_coverage(bs = test, min_count = 10, max_count = 500)
}
