% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_dss_test.R
\name{diff_dss_test}
\alias{diff_dss_test}
\title{Calculates differential methylation statistics under general experimental design}
\usage{
diff_dss_test(
  bs,
  diff_fit,
  contrast,
  methylation_group_column = NA,
  methylation_groups = NA
)
}
\arguments{
\item{bs}{a \code{BSseq}, the same used used to create \code{diff_fit}.}

\item{diff_fit}{a \code{list} object output by \code{diff_dss_fit()}.}

\item{contrast}{a contrast matrix for hypothesis testing. The number of rows should match the number of columns \code{design}. Consult \code{diff_fit$X} to ensure the contrast correponds to the intended test.}

\item{methylation_group_column}{Optionally, a column from \code{diff_fit$design} by which to group samples and capture methylation rates. This column can be a \code{character}, \code{factor}, or \code{numeric}. In the case of \code{numeric} the samples are grouped according to the top and bottom 25 percentiles of the covariate, and the mean methlyation for each group is calculated. If not a \code{numeric}, use the \code{methylation_groups} parameter to specify case and control.}

\item{methylation_groups}{Optionally, a named \code{character} vector indicating the \code{case} and \code{control} factors of \code{methylation_group_column} by which to group samples and capture methylation rates. If specified, must also specify \code{methylation_group_column}.}
}
\value{
A \code{GRanges} object containing the following \code{mcols}:
\describe{
  \item{stat:}{ The test statistic. }
  \item{pvalue:}{ The p-value. }
  \item{fdr:}{ The Benjamini-Hochberg adjusted p-values using \code{p.adjust(method = 'BH')}. }
}
If \code{methylation_group_column} is specified, also the following \code{mcols}:
\describe{
  \item{meth_case:}{ Methylation estimate for case. }
  \item{meth_control:}{ Methylation estimate for control. }
  \item{meth_diff:}{ The difference \code{meth_case - meth_control}. }
  \item{direction:}{ The group for which the locus is hyper-methylated. Note, this is not subject to significance thresholds. }
}
}
\description{
This function is a wrapper for \code{DSS::DMLtest.multiFactor} with the added feature of reporting methylation rates alongside the test results via the \code{methylation_group_column} and \code{methylation_groups} parameters. See documentation below.
}
\examples{
data(BS.cancer.ex, package = 'bsseqData')

bs = filter_loci_by_group_coverage(
    bs = BS.cancer.ex,
    group_column = 'Type',
    c('cancer' = 2, 'normal' = 2))

small_test = bs[1:50]

diff_fit = diff_dss_fit(
    bs = small_test,
    design = bsseq::pData(bs),
    formula = '~ Type')

result = diff_dss_test(
    bs = small_test,
    diff_fit = diff_fit,
    contrast = matrix(c(0,1), ncol = 1)
)

result_with_meth = diff_dss_test(
    bs = small_test,
    diff_fit = diff_fit,
    contrast = matrix(c(0,1), ncol = 1),
    methylation_group_column = 'Type',
    methylation_groups = c('case' = 'cancer', 'control' = 'normal')
)

}
