% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffMeth.R
\docType{class}
\name{methylDiff-class}
\alias{methylDiff-class}
\alias{methylDiff}
\title{An S4 class that holds differential methylation information}
\description{
This class is designed to hold statistics and locations for differentially 
methylated regions/bases. It extends \code{\link{data.frame}} class.
\code{\link{calculateDiffMeth}} function returns an object 
with \code{methylDiff} class.
}
\section{Slots}{
\describe{
   \item{\code{sample.ids}}{ids/names of samples in a vector}
   \item{\code{assembly}}{a name of genome assembly, such as :hg18,mm9, etc}
   \item{\code{context}}{numeric vector identifying which samples are which
   group }
   \item{\code{treatment}}{numeric vector identifying which samples are which
    group }
   \item{\code{destranded}}{logical denoting if methylation inormation is
    destranded or not}
   \item{\code{resolution}}{string either 'base' or 'region' defining the 
   resolution of methylation information}
   \item{\code{.Data}}{data.frame holding the locations and statistics}

}
}

\section{Details}{

\code{methylDiff} class extends \code{\link{data.frame}} class therefore
 providing novice and experienced R users with a data structure that is 
 well known and ubiquitous in many R packages.
}

\section{Subsetting}{

 In the following code snippets, \code{x} is a \code{methylDiff} object.
 Subsetting by \code{x[i,]} will produce a new object if subsetting is done 
 on rows. Column subsetting is not directly allowed to prevent errors in the 
 downstream analysis. see ?methylKit[ .
}

\section{Coercion}{

  \code{methylDiff} object can be coerced to 
  \code{\link[GenomicRanges:GRanges-class]{GRanges}} object via \code{\link{as}} function.
}

\section{Accessors}{
 
The following functions provides access to data slots of methylDiffDB:
- \code{\link{getData}}: get the data slot from the methylKit objects,
- \code{\link{getAssembly}}: get assembly of the genome,
- \code{\link{getContext}}: get the context of methylation
}

\examples{
data(methylKit)
library(GenomicRanges)
my.gr=as(methylDiff.obj,"GRanges")

}
