% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methSeg.R
\docType{methods}
\name{methSeg2bed}
\alias{methSeg2bed}
\title{Export segments to BED files}
\usage{
methSeg2bed(
  segments,
  filename,
  trackLine = "track name='meth segments' description='meth segments' itemRgb=On",
  colramp = colorRamp(c("gray", "green", "darkgreen"))
)
}
\arguments{
\item{segments}{\code{\link[GenomicRanges:GRanges-class]{GRanges}} object with segment
       classification and information. This should be the result of 
\code{\link{methSeg}} function}

\item{filename}{name of the output data}

\item{trackLine}{UCSC browser trackline}

\item{colramp}{color scale to be used in the BED display
defaults to gray,green, darkgreen scale.}
}
\value{
A BED files with the segmented data
which can be visualized in the UCSC browser
}
\description{
The segments are color coded based on their score (methylation or differential
methylation value). They are named by segment group (components in mixture modeling)
and the score in the BED file is obtained from 'seg.mean' column of segments
object.
}
\seealso{
\code{\link{methSeg}}
}
