% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{getTreatment}
\alias{getTreatment}
\alias{getTreatment<-}
\alias{getTreatment,methylRawList-method}
\alias{getTreatment<-,methylRawList-method}
\alias{getTreatment,methylBase-method}
\alias{getTreatment<-,methylBase-method}
\alias{getTreatment,methylDiff-method}
\alias{getTreatment<-,methylDiff-method}
\alias{getTreatment,methylRawListDB-method}
\alias{getTreatment<-,methylRawListDB-method}
\alias{getTreatment,methylBaseDB-method}
\alias{getTreatment<-,methylBaseDB-method}
\alias{getTreatment,methylDiffDB-method}
\alias{getTreatment<-,methylDiffDB-method}
\alias{getTreatment,getTreatment,methylDiffDB-method}
\title{Get or Set treatment vector of methylKit object}
\usage{
getTreatment(x)
getTreatment(x) <- value

getTreatment(x) <- value

\S4method{getTreatment}{methylRawList}(x)

\S4method{getTreatment}{methylRawList}(x) <- value

\S4method{getTreatment}{methylBase}(x)

\S4method{getTreatment}{methylBase}(x) <- value

\S4method{getTreatment}{methylDiff}(x)

\S4method{getTreatment}{methylDiff}(x) <- value

\S4method{getTreatment}{methylRawListDB}(x)

\S4method{getTreatment}{methylRawListDB}(x) <- value

\S4method{getTreatment}{methylBaseDB}(x)

\S4method{getTreatment}{methylBaseDB}(x) <- value

\S4method{getTreatment}{methylDiffDB}(x)

\S4method{getTreatment}{methylDiffDB}(x) <- value
}
\arguments{
\item{x}{a \code{methylKit} object}

\item{value}{a valid replacement for the treatment vector of the object}
}
\description{
The function returns or replaces the treatment vector stored in any of the 
following methylKit objects:
\code{\link{methylBase}},\code{\link{methylRawList}},\code{\link{methylBaseDB}},
\code{\link{methylRawListDB}},\code{\link{methylDiff}},\code{\link{methylDiffDB}}.
}
\examples{

data(methylKit)

# The treatment vector can be printed ..
getTreatment(methylBase.obj)
 
# .. or replaced with a new one  
newObj <- methylBase.obj
getTreatment(newObj) <- c(1,2,3,4)
getTreatment(newObj)


}
