% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceMethods.R
\name{extractInfo}
\alias{extractInfo}
\title{Extract the information specific to a subsection of the permutation
analysis}
\usage{
extractInfo(
  allResults,
  type = c("sites", "tiles"),
  inter = c("i2", "iAll"),
  position = 1
)
}
\arguments{
\item{allResults}{a \code{list} of class \code{methylInheritanceAllResults}
as created by the
\code{runPermutation} function. The \code{list} must contain
two entries : \code{"PERMUTATION"} and \code{"OBSERVATION"}. The
\code{"PERMUTATION"} \code{list} must contain all results from all
permutations while
the \code{"OBSERVATION"} \code{list} must contain the result obtained with
the observed dataset (not shuffled).}

\item{type}{One of the \code{"sites"} or \code{"tiles"} strings.
Specifies the type
of differentially methylated elements should be returned. For
retrieving differentially methylated bases \code{type} = \code{"sites"}; for
differentially methylated regions \code{type} = \code{"tiles"}.
Default: \code{"sites"}.}

\item{inter}{One of the \code{"i2"} or \code{"iAll"} strings. Specifies the
type of intersection should be returned. For
retrieving intersection results between two consecutive generations
\code{inter} = \code{"i2"}; for intersection results between three
generations or more \code{inter} = \code{"iAll"}.
Default: \code{"i2"}.}

\item{position}{a positive \code{integer}, the position in the \code{list}
where the information will be extracted. Default=\code{1}.}
}
\value{
a \code{data.frame}
containing the observation results (using real
data) and the permutation results (using shuffled data). Both hyper and
hypo differentially conserved methylation results are present.
}
\description{
Extract the information specific to a subsection of the
permutation analysis. The extracted information will be specific to one
type of differential methylation analysis (tiles or sites), to one type
of intersection (two consecutive generation or more) and to one specific
group of generations.
}
\examples{

## Get the name of the directory where files are stored
filesDir <- system.file("extdata", "TEST", package="methylInheritance")

## Load information from files
results <- loadAllRDSResults(analysisResultsDir = filesDir,
    permutationResultsDir = filesDir, doingSites = TRUE, doingTiles = TRUE)

## Extract information for the intersection between conserved differentially
## methylated sites (type = sites) between the intersection of 2
## generations (inter = i2): F1 and F2 (position = 1)
info <- extractInfo(allResults = results, type = "sites", inter="i2", 1)

}
\author{
Astrid Deschenes, Pascal Belleau
}
