% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{subset_methrix}
\alias{subset_methrix}
\title{Subsets \code{\link{methrix}} object based on given conditions.}
\usage{
subset_methrix(
  m,
  regions = NULL,
  contigs = NULL,
  samples = NULL,
  overlap_type = "within"
)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{regions}{genomic regions to subset by. Could be a data.table with 3 columns (chr, start, end) or a \code{GenomicRanges} object}

\item{contigs}{chromosome names to subset by}

\item{samples}{sample names to subset by}

\item{overlap_type}{defines the type of the overlap of the CpG sites with the target region. Default value is `within`. For detailed description,
see the \code{foverlaps} function of the \code{\link{data.table}} package.}
}
\value{
An object of class \code{\link{methrix}}
}
\description{
Subsets \code{\link{methrix}} object based on given conditions.
}
\details{
Takes \code{\link{methrix}} object and filters CpGs based on coverage statistics
}
\examples{
data('methrix_data')
#Subset to chromosome 1
subset_methrix(methrix_data, contigs = 'chr21')
}
