% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapid_cor_test.R
\name{rapidCorTest}
\alias{rapidCorTest}
\title{Rapidly calculate the correlation and the significance of pairs of columns from two data.frames}
\usage{
rapidCorTest(
  table1,
  table2,
  cor_method = "pearson",
  table1_name = "table1",
  table2_name = "table2",
  p_adjust_method = "BH",
  n_covariates = 0,
  min_number_complete_pairs = 30
)
}
\arguments{
\item{table1}{A data.frame}

\item{table2}{A data.frame}

\item{cor_method}{A character string indicating which correlation coefficient is to be computed.
One of either "pearson" or "spearman" or their abbreviations.}

\item{table1_name}{Name to give the column giving the name of features in table1. Default is "table1".}

\item{table2_name}{Name to give the column giving the name of features in table2. Default is "table2".}

\item{p_adjust_method}{Method used to adjust p-values. Same as the methods from p.adjust.methods. Default is Benjamini-Hochberg.
Setting to "none" will result in no adjusted p-values being calculated.}

\item{n_covariates}{Number of covariates if calculating partial correlations. Defaults to 0.}

\item{min_number_complete_pairs}{The minimum number of complete pairs required to return a p-value for a correlation.
Correlations with less than this number are given a p-value of NaN. Default value is 30.}
}
\value{
A data.frame with the correlation and its significance for all pairs consisting of a variable from table1 and a variable from table2.
}
\description{
Rapidly calculate the correlation and the significance of pairs of columns from two data.frames
}
\examples{

# Divide mtcars into two tables
table1 <- mtcars[, 1:5]
table2 <- mtcars[, 6:11]

# Calculate correlation between table1 and table2
cor_results <- methodical::rapidCorTest(table1, table2, cor_method = "spearman",
  table1_name = "feature1", table2_name = "feature2")
head(cor_results)

}
