% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plotMethSiteCorCoefs}
\alias{plotMethSiteCorCoefs}
\title{Plot the correlation coefficients for methylation sites within a region and an associated feature of interest}
\usage{
plotMethSiteCorCoefs(
  meth_site_cor_values,
  reference_tss = FALSE,
  title = NULL,
  xlabel = NULL,
  ylabel = "Correlation Coefficient",
  value_colours = c("#7B5C90", "#bfab25"),
  reverse_x_axis = FALSE
)
}
\arguments{
\item{meth_site_cor_values}{A data.frame with correlation values associated with methylation sites, such as
returned by \code{calculateMethSiteTranscriptCors}. There should be one column called \code{meth_site} giving the
coordinates of methylation sites in character format and another column called \code{cor} giving the correlation
between the methylation values of the methylation sites and a feature of interest. All methylation sites must be
located on the same sequence.}

\item{reference_tss}{TRUE or FALSE indicating whether to show distances on the X-axis
relative to the TSS stored as an attribute \code{tss_range} of meth_site_cor_values.
Alternatively, can provide a GRanges object with a single range for such a TSS site.
In either case, will show the distance of methylation sites to the start of this region with methylation sites upstream
relative to the reference_tss shown first.
If FALSE (the default), the x-axis will instead show the start site coordinate of the methylation site.}

\item{title}{Title of the plot. Default is no title.}

\item{xlabel}{Label for the X axis in the plot. Defaults to "Distance to TSS" if reference_tss is used or
"seqname position" where seqname is the name of the relevant sequence.}

\item{ylabel}{Label for the Y axis in the plot. Default is "Correlation Coefficient".}

\item{value_colours}{A vector with two colours to use, the first for low values and the second for high values. Defaults are c("#7B5C90", "#bfab25").}

\item{reverse_x_axis}{TRUE or FALSE indicating whether x-axis should be reversed,
for example if plotting a region on the reverse strand so that left side of plot corresponds to upstream.}
}
\value{
A ggplot object
}
\description{
Plot the correlation coefficients for methylation sites within a region and an associated feature of interest
}
\examples{
# Load methylation-transcript correlation results for TUBB6 gene
data("tubb6_cpg_meth_transcript_cors", package = "methodical")

# Plot methylation-transcript correlation values around TUBB6 TSS
methodical::plotMethSiteCorCoefs(tubb6_cpg_meth_transcript_cors, ylabel = "Spearman Correlation")

# Create same plot but showing the distance to the TUBB6 TSS on the x-axis
methodical::plotMethSiteCorCoefs(tubb6_cpg_meth_transcript_cors, 
  ylabel = "Spearman Correlation", reference_tss = attributes(tubb6_cpg_meth_transcript_cors)$tss_range)

}
