% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{getDiffCase}
\alias{getDiffCase}
\title{Get the C/T proportion at a selected site,
differentially methylated or not, for all cases}
\usage{
getDiffCase(ctrlMean, ctrlVar, selectedAsDM, nbCase, sDiff, nbDiffCase)
}
\arguments{
\item{ctrlMean}{a \code{double}, the mean of the CTRL at the site.}

\item{ctrlVar}{a \code{double}, the variance of the CTRL at the site.}

\item{selectedAsDM}{a \code{integer}, \code{1} if the site is selected as 
differentially methylated, otherwise \code{0}.}

\item{nbCase}{a \code{integer}, the number of cases.}

\item{sDiff}{a non-negative \code{double} 
included in [0,1], the proportion of C/T for a case differentially 
methylated that follows 
a beta distribution where the mean is shifted of \code{vDiff} 
from the CTRL distribution.}

\item{nbDiffCase}{an \code{integer}, the number of cases differentially 
methylated.}
}
\value{
a \code{vector} containing 3 + \code{nbCase} entries of type 
\code{double}:
\itemize{
\item The mean proportion of C/T of the differentially methylated cases
\item The number of cases simulated using shifted distribution
\item The number of cases simulated using the control distribution
\item The proportion of C/T for each case
}
}
\description{
Simulate the proportion of C/T for each case at a selected 
site, differentially methylated or not.
}
\examples{

## Fix seed to obtain replicable results
set.seed(2010)

## Get the proportion of C/T for each case at a specific site.
methInheritSim:::getDiffCase(ctrlMean = 0.9814562, ctrlVar = 
0.0003607153, selectedAsDM = 0, nbCase=6, sDiff = 0.8, 
nbDiffCase = round(6 * 0.9))

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
