/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.utils;

import fr.cea.ig.metatarget.utils.NamedThreadFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelFor {
    private static final int NUM_CORES = Runtime.getRuntime().availableProcessors();
    private static final ForkJoinPool fjPool = new ForkJoinPool(NUM_CORES, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);

    public static <T> void blockingFor(Iterable<? extends T> elements, Operation<T> operation) {
        ParallelFor.blockingFor(2 * NUM_CORES, elements, operation);
    }

    public static <T> void blockingFor(int numThreads, Iterable<? extends T> elements, Operation<T> operation) {
        ParallelFor.For(numThreads, new NamedThreadFactory("Parallel.For"), elements, operation, Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    public static <T> void For(Iterable<? extends T> elements, Operation<T> operation) {
        ParallelFor.For(2 * NUM_CORES, elements, operation);
    }

    public static <T> void For(int numThreads, Iterable<? extends T> elements, Operation<T> operation) {
        ParallelFor.For(numThreads, new NamedThreadFactory("Parallel.For"), elements, operation, null, null);
    }

    public static <S extends T, T> void For(int numThreads, NamedThreadFactory threadFactory, Iterable<S> elements, final Operation<T> operation, Integer wait, TimeUnit waitUnit) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        final ThreadSafeIterator<S> itr = new ThreadSafeIterator<S>(elements.iterator());
        for (int i = 0; i < threadPoolExecutor.getMaximumPoolSize(); ++i) {
            threadPoolExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    Object element;
                    while ((element = itr.next()) != null) {
                        try {
                            operation.perform(element);
                        }
                        catch (Exception e) {
                            Logger.getLogger(ParallelFor.class.getName()).log(Level.SEVERE, "Exception during execution of parallel task", e);
                        }
                    }
                    return null;
                }
            });
        }
        threadPoolExecutor.shutdown();
        if (wait != null) {
            try {
                threadPoolExecutor.awaitTermination(wait.intValue(), waitUnit);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static <T> void ForFJ(Iterable<T> elements, Operation<T> operation) {
        fjPool.invokeAll(ParallelFor.createCallables(elements, operation));
    }

    public static <T> Collection<Callable<Void>> createCallables(Iterable<T> elements, final Operation<T> operation) {
        LinkedList<Callable<Void>> callables = new LinkedList<Callable<Void>>();
        for (final T elem : elements) {
            callables.add(new Callable<Void>(){

                @Override
                public Void call() {
                    operation.perform(elem);
                    return null;
                }
            });
        }
        return callables;
    }

    public static interface Operation<T> {
        public void perform(T var1);
    }

    private static class ThreadSafeIterator<T> {
        private final Iterator<T> itr;

        public ThreadSafeIterator(Iterator<T> itr) {
            this.itr = itr;
        }

        public synchronized T next() {
            return this.itr.hasNext() ? (T)this.itr.next() : null;
        }
    }
}

