% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meshSim.R
\name{meshSim}
\alias{meshSim}
\title{meshSim}
\usage{
meshSim(meshID1, meshID2, measure = "Wang", semData)
}
\arguments{
\item{meshID1}{MeSH term vector}

\item{meshID2}{MeSH term vector}

\item{measure}{one of "Wang", "Resnik", "Rel", "Jiang" and "Lin"}

\item{semData}{annotation data for semantic measurement, output by meshdata function}
}
\value{
score matrix
}
\description{
semantic similarity between two MeSH term vectors
}
\examples{
## library(meshes)
## library(AnnotationHub)
## ah <- AnnotationHub()
## qr_hsa <- query(ah, c("MeSHDb", "Homo sapiens"))
## filepath_hsa <- qr_hsa[[1]]
## db <- MeSHDbi::MeSHDb(filepath_hsa)
## hsamd <- meshdata(db, category='A', computeIC=T, database="gendoo")
data(hsamd)
meshSim("D000009", "D009130", semData=hsamd, measure="Resnik")
}
\author{
Guangchuang Yu \url{https://guangchuangyu.github.io}
}
