% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseMeSH.R
\name{gseMeSH}
\alias{gseMeSH}
\title{gseMeSH}
\usage{
gseMeSH(
  geneList,
  MeSHDb,
  database = "gendoo",
  category = "C",
  nPerm = 1000,
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{MeSHDb}{MeSHDb}

\item{database}{one of 'gendoo', 'gene2pubmed' or 'RBBH'}

\item{category}{one of "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L","M", "N", "V", "Z"}

\item{nPerm}{number of permutations.}

\item{exponent}{weight of each step}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{pvalueCutoff}{pvalue Cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{verbose}{print message or not}

\item{...}{other parameter}
}
\value{
gseaResult object
}
\description{
Gene Set Enrichment Analysis of MeSH
}
\examples{
\dontrun{
library(meshes)
library(AnnotationHub)
ah <- AnnotationHub()
qr_hsa <- query(ah, c("MeSHDb", "Homo sapiens"))
filepath_hsa <- qr_hsa[[1]]
db <- MeSHDbi::MeSHDb(filepath_hsa)
data(geneList, package="DOSE")
y <- gseMeSH(geneList, MeSHDb = db, database = 'gene2pubmed', category = "G")
}
}
\author{
Yu Guangchuang
}
