% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneEvents.R
\name{plotGenePSI}
\alias{plotGenePSI}
\title{Boxplots of Percent spliced-in levels for gene events.}
\usage{
plotGenePSI(events, type = c("A3SS", "A5SS", "SE", "RI", "MXE"),
  show_replicates = TRUE)
}
\arguments{
\item{events}{a maser object.}

\item{type}{character indicating splice type. Possible values 
are \code{c("A3SS", "A5SS", "SE", "RI", "MXE")}}

\item{show_replicates}{logical, add data points for individual
replicates}
}
\value{
a ggplot object.
}
\description{
Boxplots of Percent spliced-in levels for gene events.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)
hypoxia_mib2 <- geneEvents(hypoxia_filt, geneS = "MIB2")
plotGenePSI(hypoxia_mib2, type = "SE", show_replicates = TRUE)
}
