% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvents.R
\name{display}
\alias{display}
\title{Visualization of splicing events annotation using an interactive data table.}
\usage{
display(events, type = c("A3SS", "A5SS", "SE", "RI", "MXE"))
}
\arguments{
\item{events}{a maser object.}

\item{type}{character indicating splice type. Possible values are
\code{c("A3SS", "A5SS", "SE", "RI", "MXE")}}
}
\value{
a datatables object.
}
\description{
Visualization of splicing events annotation using an interactive data table.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)
hypoxia_top <- topEvents(hypoxia_filt)
display(hypoxia_top, type = "SE")
}
