\name{swirl}
\alias{swirl}
\alias{swirl.1.spot}
\alias{swirl.2.spot}
\alias{swirl.3.spot}
\alias{swirl.4.spot}
\alias{fish.gal}
\alias{SwirlSample.txt}
\alias{SwirlSample}


\title{Gene expression data from Swirl zebrafish cDNA microarray experiment}

\description{
  The \code{swirlRaw} dataset consists of an object \code{swirl}
  of class \code{\link{marrayRaw}}, which represents
  pre-normalization intensity data for a batch of cDNA microarrays.
  
  This experiment was carried out
using zebrafish as a model organism to study early development in
vertebrates. Swirl is a point mutant in the BMP2 gene that affects the
dorsal/ventral body axis. Ventral fates such as blood are reduced, whereas
dorsal structures such as somites and notochord are expanded. A goal of
the Swirl experiment is to identify genes with altered expression in
the swirl mutant compared to wild-type zebrafish. Two sets of dye-swap experiments were performed, for a total of four replicate hybridizations. For
each of these hybridizations, target cDNA from the swirl mutant was labeled using
one of the Cy3 or Cy5 dyes and the target cDNA wild-type mutant was labeled using
the other dye. Target cDNA was hybridized to microarrays containing
8,448 cDNA probes, including 768 controls spots (e.g. negative, positive,
and normalization controls spots). Microarrays were printed using \eqn{4 \times 4} print-tips and are thus partitioned into a \eqn{4 \times 4} grid matrix. Each grid consists of a \eqn{22\times 24} spot matrix that was printed with a single print-tip. Here, spot row and plate coordinates should coincide, as each row of spots corresponds to probe sequences from the same 384 well-plate.\cr


Each of the four hybridizations produced
a pair of 16-bit images, which were processed using the image analysis software package \code{Spot}. Raw images of the Cy3 and Cy5 fluorescence intensities for all fourhybridizations are available at \url{http://fgl.lsa.berkeley.edu/Swirl/index.html}.the dataset includes four output files
\code{swirl.1.spot},
\code{swirl.2.spot},
\code{swirl.3.spot}, and
\code{swirl.4.spot}
from the \code{Spot} package.  Each of these files contains
8,448 rows and 30 columns; rows correspond to spots and columns to
different statistics from the \code{Spot} image analysis output. The file
\code{fish.gal} is a gal file generated by the \code{GenePix} program; it contains information on individual probe sequences, such as gene names, spot ID, spot coordinates.  Hybridization information for the mutant and wild-type target samples is stored in \code{SwirlSample.txt}.


}

\usage{data(swirl)}

\source{These data were provided by Katrin Wuennenberg-Stapleton from the Ngai Lab at UC Berkeley. The swirl embryos for this experiment were provided by David Kimelman and David
Raible at the University of Washington.}

\keyword{datasets}


