% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_title.R
\name{wrap_title}
\alias{wrap_title}
\title{Wrap Long Titles with Capital Letter Prioritization (when no symbols are
nearby)}
\usage{
wrap_title(title, width = 30)
}
\arguments{
\item{title}{A character string representing the title to be wrapped.
\strong{(Required)}}

\item{width}{A numeric value specifying the maximum width for each line.
The default is 30 characters. \strong{(Optional)}}
}
\value{
A character string with the title wrapped into multiple lines.
Each line will not exceed the specified width,
with breaks prioritized by symbols when nearby, and capital letters used
only when no symbols are present.
}
\description{
This function wraps long titles into multiple lines to fit a specified width,
prioritizing breaks at symbols like
underscores, hyphens, and colons when they are close to the wrap point. If no
special symbol is found nearby, the function
will break the title at the first capital letter. If neither is found, the
title is broken at the specified width.
}
\keyword{internal}
