% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R,
%   R/methods-InteractionJaggedArray.R
\docType{class}
\name{InteractionJaggedArray-class}
\alias{InteractionJaggedArray-class}
\alias{InteractionJaggedArray}
\alias{show,InteractionJaggedArray-method}
\alias{dim,InteractionJaggedArray-method}
\alias{interactions,InteractionJaggedArray-method}
\alias{metadata,InteractionJaggedArray-method}
\alias{colData,InteractionJaggedArray-method}
\alias{counts,InteractionJaggedArray-method}
\alias{path,InteractionJaggedArray-method}
\alias{length,InteractionJaggedArray-method}
\alias{[,InteractionJaggedArray,ANY,ANY,ANY-method}
\title{InteractionJaggedArray Class}
\usage{
\S4method{show}{InteractionJaggedArray}(object)

\S4method{dim}{InteractionJaggedArray}(x)

\S4method{interactions}{InteractionJaggedArray}(x)

\S4method{metadata}{InteractionJaggedArray}(x)

\S4method{colData}{InteractionJaggedArray}(x)

\S4method{counts}{InteractionJaggedArray}(object)

\S4method{path}{InteractionJaggedArray}(object)

\S4method{length}{InteractionJaggedArray}(x)

\S4method{[}{InteractionJaggedArray,ANY,ANY,ANY}(x, i, j)
}
\arguments{
\item{object}{InteractionJaggedArray object.}

\item{x}{An InteractionJaggedArray object.}

\item{i}{Numeric vector indicating the indices
of interactions to extract.}

\item{j}{Numeric vector indicating the indices
of files to extract.}
}
\value{
`InteractionJaggedArray()` creates
 an InteractionJaggedArray object.

`dim()` returns a list of the dimensions
 of the interactions, files, and count matrices.

`interactions()` returns the interactions.

`metadata()` returns the metadata.

`colData()` returns the column data.

`counts()` returns the JaggedArray object
 containing count matrix information.

`path()` returns a character vector with
 the path to the HDF5 file with the JaggedArray data.

`length()` returns an integer with the
 number of interactions in an InteractionJaggedArray object.

Subsetting returns an InteractionJaggedArray
 or InteractionArray object (see Details).
}
\description{
The `InteractionJaggedArray` class creates
a container for storing interaction data
alongside irregular arrays. This allows the
storage of matrices with different dimensions
on-disk using HDF5.

Subset an InteractionJaggedArray by its interactions
([i,]) or its Hi-C files ([,j]).
}
\details{
The object returned will be a InteractionJaggedArray
if the submatrices contain different dimensions.
However, the returned object will automatically
be coerced into a InteractionArray if possible (i.e.
the dimensions of the rows and columns of
submatrices are the same.)
}
\section{Slots}{

\describe{
\item{\code{interactions}}{A GInteractions object.}

\item{\code{colData}}{Column data describing Hi-C files.}

\item{\code{counts}}{A JaggedArray object with data.}

\item{\code{metadata}}{List of metadata describing the
object.}
}}

\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Create test interactions
gi <- read.table(text="
            1 51000000 51300000 1 51000000 51500000
            2 52000000 52300000 3 52000000 52500000
            1 150000000 150500000 1 150000000 150300000
            2 52000000 52300000 2 52000000 52800000") |>
    as_ginteractions()

## InteractionJaggedArray object
iarr <- pullHicMatrices(gi, hicFiles, 100e03, half="both")
iarr

## Show dimensions
dim(iarr)

## Access interactions
interactions(iarr)

## Access metadata
metadata(iarr)

## Access colData
colData(iarr)

## Access count matrices
counts(iarr)

## Access path to HDF5 data
path(iarr)

## length
length(iarr)

## Subsetting
iarr[1:3,1]

}
