% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMafSummary.R
\name{plotmafSummary}
\alias{plotmafSummary}
\title{Plots maf summary.}
\usage{
plotmafSummary(
  maf,
  rmOutlier = TRUE,
  dashboard = TRUE,
  titvRaw = TRUE,
  log_scale = FALSE,
  addStat = NULL,
  showBarcodes = FALSE,
  fs = 1,
  textSize = 0.8,
  color = NULL,
  titleSize = c(1, 0.8),
  titvColor = NULL,
  top = 10
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{rmOutlier}{If TRUE removes outlier from boxplot.}

\item{dashboard}{If FALSE plots simple summary instead of dashboard style.}

\item{titvRaw}{TRUE. If false instead of raw counts, plots fraction.}

\item{log_scale}{FALSE. If TRUE log10 transforms Variant Classification, Variant Type and Variants per sample sub-plots.}

\item{addStat}{Can be either mean or median. Default NULL.}

\item{showBarcodes}{include sample names in the top bar plot.}

\item{fs}{base size for text. Default 1}

\item{textSize}{font size if showBarcodes is TRUE. Default 0.8}

\item{color}{named vector of colors for each Variant_Classification.}

\item{titleSize}{font size for title and subtitle. Default c(10, 8)}

\item{titvColor}{colors for SNV classifications.}

\item{top}{include top n genes dashboard plot. Default 10.}
}
\value{
Prints plot.
}
\description{
Plots maf summary.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf, useAll = FALSE)
plotmafSummary(maf = laml, addStat = 'median')
}
\seealso{
\code{\link{read.maf}} \code{\link{MAF}}
}
