% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOncodriveClust.R
\name{plotOncodrive}
\alias{plotOncodrive}
\title{Plots results from \code{oncodrive}}
\usage{
plotOncodrive(
  res = NULL,
  fdrCutOff = 0.05,
  useFraction = FALSE,
  colCode = NULL,
  bubbleSize = 1,
  labelSize = 1
)
}
\arguments{
\item{res}{results from \code{\link{oncodrive}}}

\item{fdrCutOff}{fdr cutoff to call a gene as a driver.}

\item{useFraction}{if TRUE uses a fraction of total variants as X-axis scale instead of absolute counts.}

\item{colCode}{Colors to use for indicating significant and non-signififcant genes. Default NULL}

\item{bubbleSize}{Size for bubbles. Default 2.}

\item{labelSize}{font size for labelling genes. Default 1.}
}
\value{
Nothing
}
\description{
Takes results from \code{oncodrive} and plots them as a scatter plot. Size of the gene shows number of clusters (hotspots), x-axis can either be an absolute number of variants
accumulated in these clusters or a fraction of total variants found in these clusters. y-axis is fdr values transformed into -log10 for better representation. Labels indicate Gene name with number clusters
observed.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
laml.sig <- oncodrive(maf = laml, AACol = 'Protein_Change', minMut = 5)
plotOncodrive(res = laml.sig, fdrCutOff = 0.1)

}
\seealso{
\code{\link{oncodrive}}
}
