% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathScore.R
\name{math.score}
\alias{math.score}
\title{calculates MATH (Mutant-Allele Tumor Heterogeneity) score.}
\usage{
math.score(maf, vafCol = NULL, sampleName = NULL, vafCutOff = 0.075)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{vafCol}{manually specify column name for vafs. Default looks for column 't_vaf'}

\item{sampleName}{sample name for which MATH score to be calculated. If NULL, calculates for all samples.}

\item{vafCutOff}{minimum vaf for a variant to be considered for score calculation. Default 0.075}
}
\value{
\code{data.table} with MATH score for every Tumor_Sample_Barcode
}
\description{
calcuates MATH scores from variant allele frequencies. Mutant-Allele Tumor Heterogeneity (MATH) score is a measure of  intra-tumor genetic heterogeneity.
High MATH scores are related to lower survival rates. This function requies vafs.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
laml.math <- math.score(maf = laml, vafCol = 'i_TumorVAF_WU',
sampleName = c('TCGA-AB-3009', 'TCGA-AB-2849', 'TCGA-AB-3002', 'TCGA-AB-2972'))
}
\references{
Mroz, Edmund A. et al. Intra-Tumor Genetic Heterogeneity and Mortality in Head and Neck Cancer: Analysis of Data from The Cancer Genome Atlas. Ed. Andrew H. Beck. PLoS Medicine 12.2 (2015): e1001786.
}
