% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafbarplot.R
\name{mafbarplot}
\alias{mafbarplot}
\title{Creates a bar plot}
\usage{
mafbarplot(
  maf,
  n = 20,
  genes = NULL,
  color = NULL,
  fontSize = 0.7,
  includeCN = FALSE,
  legendfontSize = 0.7,
  borderCol = "#34495e",
  showPct = TRUE
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object}

\item{n}{Number of genes to include. Default 20.}

\item{genes}{Manually provide names of genes. Default NULL.}

\item{color}{named vector of colors for each Variant_Classification. Default NULL.}

\item{fontSize}{Default 0.7}

\item{includeCN}{Include copy number events if available? Default FALSE}

\item{legendfontSize}{Default 0.7}

\item{borderCol}{Default "#34495e". Set to `NA` for no border color.}

\item{showPct}{Default TRUE. Show percent altered samples.}
}
\description{
Takes an MAF object and generates a barplot of mutated genes color coded for variant classification
}
\examples{
laml.maf = system.file("extdata", "tcga_laml.maf.gz", package = "maftools") #MAF file
laml = read.maf(maf = laml.maf)
mafbarplot(maf = laml)

}
