% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafCompare.R
\name{mafCompare}
\alias{mafCompare}
\title{compare two cohorts (MAF).}
\usage{
mafCompare(
  m1,
  m2,
  m1Name = NULL,
  m2Name = NULL,
  minMut = 5,
  useCNV = TRUE,
  pathways = NULL,
  custom_pw = NULL,
  pseudoCount = FALSE
)
}
\arguments{
\item{m1}{first \code{\link{MAF}} object}

\item{m2}{second \code{\link{MAF}} object}

\item{m1Name}{optional name for first cohort}

\item{m2Name}{optional name for second cohort}

\item{minMut}{Consider only genes with minimum this number of samples mutated in atleast one of the cohort for analysis. Helful to ignore single mutated genes. Default 5.}

\item{useCNV}{whether to include copy number events. Default TRUE if available.. Not applicable when `pathways = TRUE`}

\item{pathways}{Summarize genes by pathways before comparing. Can be either `sigpw` or `smgbp`,  `sigpw` uses known oncogenic signalling pathways (Sanchez/Vega et al) whereas `smgbp` uses pan cancer significantly mutated genes classified according to biological process (Bailey et al). Default \code{NULL}}

\item{custom_pw}{Optional. Can be a two column data.frame/tsv-file with pathway-name and genes involved in them. Default `NULL`. This argument is mutually exclusive with \code{pathdb}}

\item{pseudoCount}{If TRUE, adds 1 to the contingency table with 0's to avoid `Inf` values in the estimated odds-ratio.}
}
\value{
result list
}
\description{
compare two cohorts (MAF).
}
\details{
Performs fisher test on 2x2 contigency table generated from two cohorts to find differentially mutated genes.
}
\examples{
primary.apl <- system.file("extdata", "APL_primary.maf.gz", package = "maftools")
relapse.apl <- system.file("extdata", "APL_relapse.maf.gz", package = "maftools")
primary.apl <- read.maf(maf = primary.apl)
relapse.apl <- read.maf(maf = relapse.apl)
pt.vs.rt <- mafCompare(m1 = primary.apl, m2 = relapse.apl, m1Name = 'Primary',
m2Name = 'Relapse', minMut = 5)
}
\seealso{
\code{\link{forestPlot}}

\code{\link{lollipopPlot2}}
}
