\name{IsoModel}
\alias{IsoModel}

\title{Detection of genes with Isoforms with different gene expression in time course experiments}
\description{
     \code{IsoModel} Performs a model comparison for each gene to detect genes with different trends in time course experiments and applies maSigPro to the Isoforms belonging to selected genes.
}
\usage{
IsoModel(data, gen, design = NULL, Q = 0.05, min.obs = 6, minorFoldfilter = NULL,
    counts = FALSE, family = NULL, theta = 10, epsilon = 1e-05)
}

\arguments{
  \item{data}{matrix containing isoform expression. Isoforms must be in rows and experimental conditions in columns}
  \item{gen}{vector with the name of the gene each isoform belongs to}
  \item{design}{design matrix for the regression fit such as that generated by the \code{\link{make.design.matrix}} function}
  \item{Q}{significance level}
  \item{min.obs}{cases with less than this number of true numerical values will be excluded from the analysis. Minimum value to estimate the model is (degree+1)xGroups+1. Default is  6.  }
  \item{minorFoldfilter}{fold expression difference between minor isoforms and the most expressed isoform to exclude minor isoforms from analysis. Default NULL }
  \item{counts}{a logical indicating whether your data are counts}
  \item{family}{the distribution function to be used in the glm model. It must be specified as a function: gaussian(), poisson(), negative.binomial(theta)...
		If NULL family will be negative.binomial(theta) when counts=TRUE or gaussian() when counts=FALSE }
  \item{theta}{theta parameter for negative.binomial family}
  \item{epsilon}{argument to pass to \code{glm.control}, convergence tolerance in the iterative process to estimate de glm model}
}

\details{
 \code{rownames(design)} and \code{colnames(data)} must be identical vectors and indicate experimental condition names.

 \code{rownames(data)} should contain unique isoform IDs.

 \code{colnames(design)} are the given names for the variables in the regression model.
}

\value{
  \item{data}{input data matrix to be used in the following steps}
  \item{gen}{input gen vector to be used in the following steps}
  \item{design}{input design matrix to be used in the following steps}
  \item{DSG}{Names of the selected genes: Differentially Spliced Genes}
  \item{pvector}{p.vector output of isoforms that belong to selected.genes}
  \item{Tfit}{Tfit output of isoforms that belong to selected.genes}
  }
\references{
  Nueda, M.J., Martorell, J., Marti, C., Tarazona, S., Conesa, A. 2018. Identification and visualization of differential isoform expression in RNA-seq time series. Bioinformatics. 34, 3, 524-526.

  Nueda, M.J., Tarazona, S., Conesa, A. 2014.
  Next maSigPro: updating maSigPro bioconductor package for RNA-seq time series.
  Bioinformatics, 30, 2598-602.

  Conesa, A., Nueda M.J., Ferrer, A., Talon, T. 2006.
  maSigPro: a Method to Identify Significant Differential Expression Profiles in Time-Course Microarray Experiments.
  Bioinformatics 22, 1096-1102.


}
\author{Maria Jose Nueda, \email{mj.nueda@ua.es}}

\seealso{ \code{\link{p.vector}}, \code{\link{T.fit}} }
\examples{
data(ISOdata)
data(ISOdesign)
mdis <- make.design.matrix(ISOdesign)
MyIso <- IsoModel(data=ISOdata[,-1], gen=ISOdata[,1], design=mdis, counts=TRUE)
Myget <- getDS(MyIso)
see <- seeDS(Myget, cluster.all=FALSE, k=6)
table <- tableDS(see)
table$IsoTable
}
