% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mCSEAPlot.R
\name{mCSEAPlot}
\alias{mCSEAPlot}
\title{Plot mCSEA results}
\usage{
mCSEAPlot(mCSEAResults, regionType, dmrName, extend = 1000,
  chromosome = TRUE, leadingEdge = TRUE, CGI = FALSE, genes = TRUE,
  transcriptAnnotation = "transcript", makePDF = TRUE,
  col = c("blue", "magenta", "green", "red", "black"))
}
\arguments{
\item{mCSEAResults}{The object generated by mCSEATest function}

\item{regionType}{The region type to be represented. Must be one of
"promoters", "genes", "CGI" or "custom"}

\item{dmrName}{The DMR of interest to be represented (e.g. gene name, CGI
name...)}

\item{extend}{The number of base pairs to extend the plot around the DMR
of interest (default = 1000 bp)}

\item{chromosome}{If TRUE, represent the chromosome and genome axis}

\item{leadingEdge}{If TRUE, represent the bars indicating if each CpG belongs
to the mCSEA leading edge (green) or not (red)}

\item{CGI}{If TRUE, represent the annotated CpG islands}

\item{genes}{If TRUE, represent the annotated genes}

\item{transcriptAnnotation}{Labels showed at the genes track. Must be one of
"transcript" (default), "symbol", "gene", "exon" or "feature"}

\item{makePDF}{If TRUE, save the plot in pdf format in the working
directory. Otherwise, draw the plot in the active graphics window}

\item{col}{Vector with colors to plot methylation in different groups}
}
\value{
'NULL'
}
\description{
Generate a graphic with the genomic context of the selected DMR, showing
methylation status at each CpG site of different samples groups
}
\examples{
library(mCSEAdata)
data(mcseadata)
\dontrun{
myRank <- rankProbes(betaTest, phenoTest, refGroup = "Control")
set.seed(123)
myResults <- mCSEATest(myRank, betaTest, phenoTest,
regionsTypes = "promoters", platform = "EPIC")
}
data(precomputedmCSEA)
mCSEAPlot(myResults, "promoters", "CLIC6",
transcriptAnnotation = "symbol", makePDF = FALSE)
}
\seealso{
\code{\link{rankProbes}}, \code{\link{mCSEATest}},
\code{\link{mCSEAPlotGSEA}}
}
\author{
Jordi Martorell Marugán, \email{jordi.martorell@genyo.es}
}
