\name{plot.predict.survivalFS}
\alias{plot.predict.survivalFS}
\alias{print.predict.survivalFS}

\title{Survival and Cumulative Hazard Function Plot}
\description{
  Plots predicted survival or cumulative hazard curves of new 
  observations for an object of class \code{predict.survivalFS}.
}

\usage{
\method{plot}{predict.survivalFS}(x, select_obs, xlab = "time", ylab = NULL, 
              ylim = NULL, type = "l", main = NULL, sub = NULL, 
              vec_col = NULL, vec_lty = NULL, addLegend = TRUE, ...)
}

\arguments{
  \item{x}{an object of class \code{predict.survivalFS} as generated by the 
  function \code{predict.logicBagg}.}
  \item{select_obs}{a numeric vector identifying the observations whose 
  survival curves should be plotted. If \code{is.missing(select.obs)} 
  the first five observations, or, if the number of observations is less than five, 
  all observations are chosen.}
  \item{xlab}{a title for the x axis: see \code{\link{title}}.}
  \item{ylab}{a title for the y axis: see \code{\link{title}}. If \code{NULL}, the title 
  is generated automatically.}
  \item{ylim}{a numeric vector of length 2 that sets the limits of the y axis. 
  If \code{NULL}, the limits are generated automatically.}
  \item{type}{character indicating the type of plotting; actually any of 
  the types as in \code{\link{plot.default}}.}
  \item{main}{an overall title for the plot: see \code{\link{title}}. If \code{NULL}, 
  the main title is generated automatically.}
  \item{sub}{a sub title for the plot: see \code{\link{title}}. If \code{NULL}, 
  the sub title is generated automatically.}
  \item{vec_col}{a numeric or character vector that specifies the plotting colors 
  of the survival curves (see \code{\link{par}}). Vector must have the same length 
  as \code{select_obs}.}
  \item{vec_lty}{a numeric or character vector that specifies the line types 
  of the survival curves (see \code{\link{par}}). Vector must have the same length 
  as \code{select_obs}.}
  \item{addLegend}{should a legend be added to the plot automatically?}
  \item{...}{Ignored.}
}

\author{Tobias Tietz, \email{tobias.tietz@hhu.de}}

\keyword{survival}
