% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/loci2pathResult-methods.R
\docType{methods}
\name{getPval}
\alias{getPval}
\alias{getPval,loci2pathResult-method}
\title{Extract tissue/geneset enrichment p-value distribution from query result}
\usage{
getPval(res, ...)

\S4method{getPval}{loci2pathResult}(res, test.method = c("gene", "eqtl",
  "glm"))
}
\arguments{
\item{res}{query result from function query.egset.list()}

\item{\dots}{additional params}

\item{test.method}{Choose which enrichment test should be used to retrive
p-values from. Options include:"gene"(default, gene-based fisher's exact 
test),"eqtl" (eqtl based fisher's exact test), "glm" (ordered query)}
}
\value{
generate pval distribution plot
}
\description{
This function extracts the enrichment p-value distribution from eQTL list 
 query result. P-values from different tissues/cell types are organized, 
 and QQ-plot is generated against uniform distribution
}
\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
getPval(result, test.method="gene")
}
\keyword{result}
