% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LISA.R
\name{regionMap}
\alias{regionMap}
\title{Plot heatmap of cell type enrichment for lisaClust regions}
\usage{
regionMap(
  cells,
  type = "bubble",
  cellType = "cellType",
  region = "region",
  limit = c(0.33, 3),
  ...
)
}
\arguments{
\item{cells}{SingleCellExperiment, SpatialExperiment or data.frame}

\item{type}{Make a "bubble" or "heatmap" plot.}

\item{cellType}{The column storing the cell types}

\item{region}{The column storing the regions}

\item{limit}{limits to the lower and upper relative frequencies}

\item{...}{Any arguments to be passed to the pheatmap package}
}
\value{
A bubble plot or heatmap
}
\description{
Plot heatmap of cell type enrichment for lisaClust regions
}
\examples{

set.seed(51773)
x <- round(c(
  runif(200), runif(200) + 1, runif(200) + 2, runif(200) + 3,
  runif(200) + 3, runif(200) + 2, runif(200) + 1, runif(200)
), 4) * 100
y <- round(c(
  runif(200), runif(200) + 1, runif(200) + 2, runif(200) + 3,
  runif(200), runif(200) + 1, runif(200) + 2, runif(200) + 3
), 4) * 100
cellType <- factor(paste("c", rep(rep(c(1:2), rep(200, 2)), 4), sep = ""))
imageID <- rep(c("s1", "s2"), c(800, 800))

cells <- data.frame(x, y, cellType, imageID)

cells <- lisaClust(cells, k = 2)

regionMap(cells)

}
