% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LISA.R
\name{inhomLocalK}
\alias{inhomLocalK}
\title{Calculate the inhomogenous local K function.}
\usage{
inhomLocalK(
  data,
  Rs = c(20, 50, 100, 200),
  sigma = 10000,
  window = "convex",
  window.length = NULL,
  minLambda = 0.05,
  lisaFunc = "K"
)
}
\arguments{
\item{data}{The data.}

\item{Rs}{A vector of the radii that the measures of association should be
calculated.}

\item{sigma}{A numeric variable used for scaling when filting inhomogeneous L-curves.}

\item{window}{Should the window around the regions be 'square', 'convex' or 'concave'.}

\item{window.length}{A tuning parameter for controlling the level of concavity.}

\item{minLambda}{Minimum value for density for scaling when fitting inhomogeneous L-curves.}

\item{lisaFunc}{Either "K" or "L" curve.}
}
\value{
A matrix of LISA curves
}
\description{
Calculate the inhomogenous local K function.
}
\examples{
library(spicyR)
# Read in data
isletFile <- system.file("extdata", "isletCells.txt.gz", package = "spicyR")
cells <- read.table(isletFile, header = TRUE)
cells$x <- cells$AreaShape_Center_X
cells$y <- cells$AreaShape_Center_Y
cells$cellType <- as.factor(sample(
  c("big", "medium", "small"),
  length(cells$AreaShape_Center_Y),
  replace = TRUE
))
cells$cellID <- as.factor(cells$ObjectNumber)

inhom <- inhomLocalK(cells[1:100, ])

}
