% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniq_variants.R
\name{uniq_variants}
\alias{uniq_variants}
\title{uniq_variants}
\usage{
uniq_variants(hits_table = NULL, AF_threshold = 0.8)
}
\arguments{
\item{hits_table}{A tab-delimited table containing the identified overlaps/hits between the
input files and the lineages' reports. This input is generated by the
\code{lineagespot_hits} function.}

\item{AF_threshold}{A parameter indicating the AF threshold that is going to applied in order to
identify the presence or not of a variant. This is used to compute the number
of variants in a sample and eventually the proportion of a lineage.}
}
\value{
A data table with metrics assessing the
abundance of every lineage in each samples
}
\description{
Lineage report for variants overlapping
}
\examples{

variants_table <- merge_vcf(
    vcf_folder = system.file("extdata", "vcf-files",
        package = "lineagespot"
    ),
    gff3_path = system.file("extdata",
        "NC_045512.2_annot.gff3",
        package = "lineagespot"
    )
)

lineage_hits_table <- lineagespot_hits(
    vcf_table = variants_table,
    ref_folder = system.file("extdata", "ref",
        package = "lineagespot")
)

report <- uniq_variants(hits_table = lineage_hits_table)
head(report)

}
