% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateTestEnrichments.R
\name{aggregateTestEnrichments}
\alias{aggregateTestEnrichments}
\title{Aggregate test enrichment results}
\usage{
aggregateTestEnrichments(result_list, column = "estimate", return_df = FALSE)
}
\arguments{
\item{result_list}{a list of results from testEnrichment}

\item{column}{the column name to aggregate (Default: estimate)}

\item{return_df}{whether to return a merged data frame}
}
\value{
a matrix for all results
}
\description{
Aggregate test enrichment results
}
\examples{

## pick some big TFBS-overlapping CpG groups
kycgDataCache(data_titles=
c("KYCG.MM285.TFBSconsensus.20220116","KYCG.MM285.chromHMM.20210210"))

sesameData::sesameDataCache(data_titles=
c("probeIDSignature", "MM285.address"))

cg_lists <- getDBs("MM285.TFBS")
queries <- cg_lists[(sapply(cg_lists, length) > 40000)]
result_list <- lapply(queries, testEnrichment, "MM285.chromHMM")
mtx <- aggregateTestEnrichments(result_list)

}
