% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KYCG_plotDot.R
\name{KYCG_plotDot}
\alias{KYCG_plotDot}
\title{Dot plot to show most enriched CG groups from testEnrichment}
\usage{
KYCG_plotDot(
  df,
  y = "-log10(FDR)",
  n = 20,
  order_by = "FDR",
  title = "Enriched Knowledgebases",
  label_by = "dbname",
  size_by = "overlap",
  color_by = "estimate",
  short_label = FALSE
)
}
\arguments{
\item{df}{KYCG result data frame}

\item{y}{the column to be plotted on y-axis}

\item{n}{number of CG groups to plot}

\item{order_by}{the column by which CG groups are ordered}

\item{title}{plot title}

\item{label_by}{the column for label}

\item{size_by}{the column by which CG group size plot}

\item{color_by}{the column by which CG groups are colored}

\item{short_label}{omit group in label}
}
\value{
grid plot object (by ggplot)
}
\description{
The input data frame should have an "estimate" and
a "FDR" columns.
}
\details{
Top CG groups are determined by estimate (descending order).
}
\examples{
KYCG_plotDot(data.frame(
  estimate=runif(10,0,10), FDR=runif(10,0,1), nD=runif(10,10,20),
  overlap=as.integer(runif(10,0,30)), group="g", dbname=seq_len(10)))
}
