% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testEnrichmentSEA.R
\name{testEnrichmentSEA}
\alias{testEnrichmentSEA}
\title{uses the GSEA-like test to estimate the association of a
categorical variable against a continuous variable.}
\usage{
testEnrichmentSEA(
  query,
  databases,
  platform = NULL,
  silent = FALSE,
  precise = FALSE,
  prepPlot = FALSE
)
}
\arguments{
\item{query}{query, if numerical, expect categorical database, if
categorical expect numerical database}

\item{databases}{database, numerical or categorical, but needs to be
different from query}

\item{platform}{EPIC, MM285, ..., infer if not given}

\item{silent}{suppress message (default: FALSE)}

\item{precise}{whether to compute precise p-value (up to numerical limit)
of interest.}

\item{prepPlot}{return the raw enrichment scores and presence vectors
for plotting}
}
\value{
A DataFrame with the estimate/statistic, p-value, and name of test
for the given results.
}
\description{
estimate represent enrichment score and negative estimate indicate a
test for depletion
}
\examples{
sesameData::sesameDataCache(data_titles=
c("KYCG.MM285.designGroup.20210210","KYCG.MM285.seqContextN.20210630",
"probeIDSignature"))
query <- getDBs("KYCG.MM285.designGroup")[["TSS"]]
res <- testEnrichmentSEA(query, "MM285.seqContextN")
}
