% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testEnrichment.R
\name{testEnrichment}
\alias{testEnrichment}
\title{Test for enrichment of query in knowledgebase sets}
\usage{
testEnrichment(
  query,
  databases = NULL,
  universe = NULL,
  alternative = "greater",
  include_genes = FALSE,
  platform = NULL,
  silent = FALSE,
  mtc_by_group = TRUE,
  mtc_method = "fdr"
)
}
\arguments{
\item{query}{For array input, a vector of probes of interest
(e.g., significant differential methylated probes). For sequencing data
input, the file name for YAME-compressed CG sets.}

\item{databases}{List of vectors corresponding to the database sets of
interest with associated meta data as an attribute to each element.
If NULL, all available databases for the platform are used. (Default: NULL)}

\item{universe}{Vector of probes in the universe set containing all
probes to be considered in the test. If NULL, will be inferred from the
provided platform. (Default: NULL)}

\item{alternative}{Test alternative: "two.sided", "greater", or "less".
(Default: "greater")}

\item{include_genes}{Include gene link enrichment testing. (Default: FALSE)}

\item{platform}{String corresponding to the type of platform to use:
MM285, EPIC, HM450, or HM27. If NULL, will be inferred from query set
probe IDs. (Default: NULL)}

\item{silent}{Suppress output messages? (Default: FALSE)}

\item{mtc_by_group}{Perform multiple testing correction within 
knowledgebase groups. (Default: TRUE)}

\item{mtc_method}{Method for multiple test correction. (Default: "fdr")}
}
\value{
A data frame containing features corresponding to the test estimate,
p-value, and type of test, ordered by significance.
}
\description{
Test for enrichment of query in knowledgebase sets
}
\examples{

library(SummarizedExperiment)
library(sesameData)
library(knowYourCG)
kycgDataCache(data_titles = "KYCG.MM285.chromHMM.20210210")
sesameDataCache("MM285.tissueSignature")
df <- rowData(sesameDataGet("MM285.tissueSignature"))
probes <- df$Probe_ID[df$branch == "B_cell"]
res <- testEnrichment(probes, "chromHMM", platform = "MM285")

\donttest{
# Define temporary directory and file URLs
temp_dir <- tempdir()
knowledgebase <- file.path(temp_dir, "ChromHMM.20220414.cm")
query <- file.path(temp_dir, "mm10_f3_10cells.cg")

# URLs for the knowledgebase and query files
knowledgebase_url <- paste0(
  "https://zenodo.org/records/18175656/files/",
  "ChromHMM.20220414.cm"
)
query_url <- paste0(
  "https://zenodo.org/records/18176004/files/",
  "mm10_f3_10cells.cg"
)

# Download the files
download.file(knowledgebase_url, destfile = knowledgebase)
download.file(query_url, destfile = query)

# Confirm file download
list.files(temp_dir)
res <- testEnrichment(query, knowledgebase)
}
}
