% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkProbesToProximalGenes.R
\name{linkProbesToProximalGenes}
\alias{linkProbesToProximalGenes}
\title{find genes in genomic proximity to given Infinium probes}
\usage{
linkProbesToProximalGenes(probeIDs, platform = NULL, genome = NULL)
}
\arguments{
\item{probeIDs}{character vector of probe IDs}

\item{platform}{HM450, EPIC, EPICv2, MM285, MSA, ..., will infer
from probe ID if not given}

\item{genome}{hg38, hg19, mm10, this is usually inferred from platform.}
}
\value{
a data frame annotate gene list linked to each given probes
}
\description{
This is a convenient function that uses sesameData_getGenomeInfo()
to retrieve stored gene models.
}
\details{
For finer control, such as taking only genes by their promoters,
please use sesameData_getTxnGRanges followed by
sesameData_annoProbes(). See code of this convenient function for details.
}
\examples{
library(SummarizedExperiment)
probes = rowData(
    sesameData::sesameDataGet('MM285.tissueSignature'))$Probe_ID[1:10]
linkProbesToProximalGenes(probes, platform = "MM285")
}
