% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ModelSelectionResult-class}
\alias{ModelSelectionResult}
\alias{ModelSelectionResult-class}
\alias{class:ModelSelectionResult}
\title{Model Selection Result Class}
\description{
Model Selection Result Class
}
\details{
Instances of this class store the result of grid search or
model selection.
}
\section{Slots}{

\describe{
\item{\code{cross}}{number of folds for cross validation}

\item{\code{noCross}}{number of CV runs}

\item{\code{groupBy}}{group assignment of samples}

\item{\code{nestedCross}}{number of folds for outer CV}

\item{\code{noNestedCross}}{number of runs of outer CV}

\item{\code{perfParameters}}{collected performance parameters}

\item{\code{perfObjective}}{performance criterion for grid search / model selection}

\item{\code{gridRows}}{rows in grid search (i.e. kernels)}

\item{\code{gridCols}}{columns in grid search}

\item{\code{gridErrors}}{grid errors}

\item{\code{gridACC}}{grid accuracy}

\item{\code{gridBACC}}{grid balanced accuracy}

\item{\code{gridMCC}}{grid Matthews correlation coefficient}

\item{\code{gridAUC}}{grid area under the ROC curve}

\item{\code{gridNoSV}}{grid number of support vectors}

\item{\code{gridSumAlphas}}{grid sum of alphas}

\item{\code{smallestCVError}}{smallest CV error}

\item{\code{selGridRow}}{grid row of best result}

\item{\code{selGridCol}}{grid col of best result}

\item{\code{fullModel}}{full model for best result}
}}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
