% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariantsColors.R
\name{getVariantsColors}
\alias{getVariantsColors}
\title{getVariantsColors}
\usage{
getVariantsColors(ref, alt, color.table=NULL, color.schema=c("cell21breast"))
}
\arguments{
\item{ref}{(character vector) The reference nucleotides of the variants. It has to have the same length as \code{alt}.}

\item{alt}{(character vector) The alternative nucleotides of the variants. It has to have the same length as \code{ref}}

\item{color.table}{(named character vector) if present, its used to assign colors to the nucleotide substitutions.}

\item{color.schema}{(character) The name of the color schema to use: \code{cell21breast} (the color schema used in "Mutational Processes Molding the Genomes of 21 Breast Cancers" by S. Nik-Zainal, Cell, 2012). (defaults to \code{cell21breast})}
}
\value{
a named character vector with the colors associated to each variant
}
\description{
Given the reference and alternative for a set of variants, assigns a color 
to each of them
}
\details{
The function creates an nucleotide substitution identifier with for each 
variant and uses it to query the color.table lookup table. If color.table
is NULL, a color.table based in the selected color.schema is used. All 
unkwonwn nucleotide substitutions are assigned a gray color. Color table 
needs to have entries for C>A, C>G, C>T, T>A, T>C and T>G (and optionally 
"others"), since other changes can be reverse complemented to these.
}
\examples{
 
ref <- c("A", "A", "C", "T", "G", "A")
alt <- c("G", "C", "T", "A", "A", "-")
getVariantsColors(ref, alt)

col.table <- c("C>A"="#FF0000", "C>G"="#000000", "C>T"="#00FF00", "T>A"="#0000FF", "T>C"="#BB00BB", "T>G"="#00BBBB", "other"="#888888")
getVariantsColors(ref, alt, col.table)


}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpPlotRainfall}}
}
