% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainIMGT.R
\name{refreshIMGT}
\alias{refreshIMGT}
\title{Force Re-download of IMGT/HLA Sequences}
\usage{
refreshIMGT(
  species = "human",
  gene,
  type = c("NUC", "PROT"),
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Character string specifying the species for which to download
data. Required for TCR/BCR queries. Currently supported species:
\code{"human"}, \code{"mouse"}, \code{"rat"}, \code{"rabbit"}, \code{"pig"},
\code{"dog"}, \code{"rhesus_monkey"}, \code{"cyno_monkey"}. Defaults to
\code{"human"} for HLA queries.}

\item{gene}{Character string specifying the gene or locus to download. For
TCR/BCR, this can be a specific chain (e.g., \code{"IGHV"}, \code{"TRBJ"})
or a group (e.g., \code{"IGH"}, \code{"TCR"}). For HLA, use \code{"HLA"}.}

\item{type}{Character string specifying the type of sequence to retrieve.
Either \code{"NUC"} for nucleotide or \code{"PROT"} for protein sequences.
This primarily distinguishes between VDJ nucleotide and V-region amino acid
sequences for TCR/BCR genes.}

\item{suppressMessages}{Logical. If \code{TRUE}, suppresses the license and
other informational messages. Default is \code{FALSE}.}
}
\value{
A \code{\link[Biostrings]{DNAStringSet}} object (when
  \code{type = "NUC"}) or \code{\link[Biostrings]{AAStringSet}} object (when
  \code{type = "PROT"}) containing the requested sequences.
}
\description{
A convenience wrapper for \code{getIMGT(..., refresh = TRUE)} to
ensure that the local cache is updated with the latest versions of the
requested sequences.
}
\examples{
if(is_imgt_available()) {
  # Force a re-download of human IGHV protein sequences
  ighv_prot_fresh <- refreshIMGT(species = "human", gene = "IGHV", type = "PROT")
}
}
\seealso{
\code{\link{getIMGT}} for the main download function

\code{\link{loadIMGT}} to load from cache without downloading
}
